/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeature;

import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.HugeMushroomGenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.FullGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;

public class HugeMushroomsGenFeature
extends HugeMushroomGenFeature {
    public static final ConfigurationProperty<Integer> MAX_MUSHROOMS = ConfigurationProperty.integer("max_mushrooms");
    public static final ConfigurationProperty<Integer> MAX_ATTEMPTS = ConfigurationProperty.integer("max_attempts");

    public HugeMushroomsGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        super.registerProperties();
        this.register(MAX_MUSHROOMS, MAX_ATTEMPTS);
    }

    @Override
    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(MAX_MUSHROOMS, 2)).with(MAX_ATTEMPTS, 4);
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        if (context.endPoints().isEmpty() || !context.isWorldGen() || context.radius() < 5) {
            return false;
        }
        LevelAccessor level = context.level();
        BlockPos rootPos = context.pos();
        BlockPos lowest = Collections.min(context.endPoints(), Comparator.comparingInt(Vec3i::m_123342_));
        RandomSource rand = context.random();
        int success = 0;
        for (int tries = 0; tries < configuration.get(MAX_ATTEMPTS); ++tries) {
            int height;
            int maxHeight;
            float angle = (float)((double)rand.m_188501_() * Math.PI * 2.0);
            int xOff = (int)(Mth.m_14031_((float)angle) * (float)(context.radius() - 1));
            int zOff = (int)(Mth.m_14089_((float)angle) * (float)(context.radius() - 1));
            BlockPos mushPos = rootPos.m_7918_(xOff, 0, zOff);
            mushPos = CoordUtils.findWorldSurface(level, new BlockPos((Vec3i)mushPos), context.isWorldGen()).m_7494_();
            if (!context.bounds().inBounds(mushPos, true) || (maxHeight = lowest.m_123342_() - mushPos.m_123342_()) < 2 || !this.setHeight(height = Mth.m_14045_((int)(rand.m_188503_(maxHeight) + 3), (int)3, (int)maxHeight)).generate(configuration, new FullGenerationContext(context.level(), context.pos(), context.species(), context.biome(), context.radius(), context.bounds())) || ++success < configuration.get(MAX_MUSHROOMS)) continue;
            return true;
        }
        return false;
    }
}

